# 🎬 GUIA DE CONTEÚDOS - HTML ESTÁTICO

Site completo em HTML puro para hospedar no SparkHost!

## ✅ FUNCIONALIDADES

1. ✅ **HTML Puro** - Sem Flask/Python
2. ✅ **TMDB API** - Dados reais de filmes/séries
3. ✅ **Botão +18 FUNCIONAL** - Mostra/esconde adultos
4. ✅ **Descrições do TMDB** - Ao clicar mostra detalhes
5. ✅ **Design igual** ao guiadeconteudo.blog

## ⚡ INSTALAÇÃO

### 1. PEGAR CHAVE TMDB

1. Acesse: https://www.themoviedb.org/
2. Crie uma conta grátis
3. Vá em: Settings → API
4. Copie a **API Key (v3 auth)**

### 2. CONFIGURAR

Abra o arquivo `js/config.js` e cole sua chave:

```javascript
const TMDB_API_KEY = 'COLE_SUA_CHAVE_AQUI';
```

### 3. HOSPEDAR NO SPARKHOST

1. Faça upload de TODOS os arquivos para o SparkHost
2. Acesse seu domínio
3. Pronto! 🚀

## 📂 ESTRUTURA

```
guia_HTML/
├── index.html         (Homepage)
├── movies.html        (Lista de filmes)
├── series.html        (Lista de séries)
├── detail.html        (Detalhes filme/série)
├── search.html        (Busca)
├── css/
│   └── style.css     (Estilos)
└── js/
    ├── config.js     (← COLOQUE SUA CHAVE AQUI)
    ├── tmdb.js       (Funções TMDB)
    ├── main.js       (Lógica principal)
    └── detail.js     (Página de detalhes)
```

## 🎯 COMO FUNCIONA

### BOTÃO +18

- Clique em "MOSTRAR +18" → Mostra conteúdo adulto
- Clique em "+18" (vermelho) → Esconde conteúdo adulto
- Salva no localStorage do navegador

### DETALHES

- Clique em qualquer filme/série
- Abre página com:
  - Poster
  - Descrição do TMDB
  - Elenco, diretor, gênero
  - Trailer do YouTube
  - Episódios (séries)
  - Ícones de plataforma

### BUSCA

- Clique no ícone 🔍
- Digite e busque
- Mostra filmes e séries

## ✅ TESTADO E FUNCIONANDO

- ✅ HTML estático
- ✅ TMDB API integrada
- ✅ Botão +18 funcional
- ✅ Descrições aparecem
- ✅ Trailer do YouTube
- ✅ Lista de episódios
- ✅ Busca funciona
- ✅ Design bonito

## 🚀 HOSPEDAGEM

**SparkHost:**
1. Upload todos os arquivos
2. Configure sua chave TMDB
3. Pronto!

**Qualquer outro host:**
- Funciona em qualquer servidor HTTP
- Não precisa PHP/Python/Node

## 📝 NOTAS

- **Chave TMDB obrigatória** - Sem ela não carrega nada
- **Filtro adultos** - Usa localStorage
- **Sem backend** - Tudo no frontend

PRONTO PARA USAR! 🎉
