// Página de detalhes

window.addEventListener('DOMContentLoaded', async () => {
    updateAdultButton();
    
    const params = new URLSearchParams(window.location.search);
    const type = params.get('type');
    const id = params.get('id');
    
    if (!type || !id) {
        window.location.href = 'index.html';
        return;
    }
    
    const loading = document.getElementById('loadingContent');
    const content = document.getElementById('detailContent');
    
    loading.style.display = 'block';
    
    try {
        if (type === 'movie') {
            await loadMovieDetail(id);
        } else if (type === 'tv') {
            await loadSeriesDetail(id);
        }
    } catch (error) {
        content.innerHTML = '<p style="text-align:center;color:#666">Erro ao carregar detalhes.</p>';
    } finally {
        loading.style.display = 'none';
    }
});

async function loadMovieDetail(id) {
    const data = await getMovieDetails(id);
    const content = document.getElementById('detailContent');
    
    const poster = data.poster_path ? `${TMDB_IMAGE_BASE}${data.poster_path}` : 'https://via.placeholder.com/350x525/1a1a1a/2196F3?text=Filme';
    const title = data.title;
    const overview = data.overview || 'Sem descrição disponível.';
    const genres = data.genres.map(g => g.name).join(', ');
    const releaseDate = data.release_date ? new Date(data.release_date).toLocaleDateString('pt-BR') : 'N/A';
    const runtime = data.runtime ? `${Math.floor(data.runtime / 60)}h ${data.runtime % 60}min` : 'N/A';
    const director = data.credits?.crew?.find(c => c.job === 'Director')?.name || 'N/A';
    const cast = data.credits?.cast?.slice(0, 5).map(c => c.name).join(', ') || 'N/A';
    const trailer = data.videos?.results?.find(v => v.type === 'Trailer' && v.site === 'YouTube');
    
    content.innerHTML = `
        <div class="detail-page">
            <h1 class="detail-title-main">${title.toUpperCase()}</h1>
            <div class="detail-container">
                <div class="poster-section">
                    <img src="${poster}" alt="${title}" class="poster-img">
                </div>
                <div class="info-section">
                    ${genres ? `<div class="info-row"><div class="info-label">Gênero:</div><div class="info-value">${genres}</div></div>` : ''}
                    ${releaseDate !== 'N/A' ? `<div class="info-row"><div class="info-label">Data de Lançamento:</div><div class="info-value">${releaseDate}</div></div>` : ''}
                    ${runtime !== 'N/A' ? `<div class="info-row"><div class="info-label">Duração:</div><div class="info-value">${runtime}</div></div>` : ''}
                    ${cast !== 'N/A' ? `<div class="info-row"><div class="info-label">Elenco:</div><div class="info-value">${cast}</div></div>` : ''}
                    ${director !== 'N/A' ? `<div class="info-row"><div class="info-label">Diretor:</div><div class="info-value">${director}</div></div>` : ''}
                    <div class="description">${overview}</div>
                    <div class="info-row"><div class="info-label">Categoria:</div><div><span class="category-badge">${genres.split(',')[0]}</span></div></div>
                </div>
            </div>
            ${trailer ? `
            <div class="trailer-section">
                <h2 class="trailer-title">🎬 Trailer</h2>
                <div class="trailer-player">
                    <iframe src="https://www.youtube.com/embed/${trailer.key}" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                </div>
            </div>` : ''}
            <div class="platforms">
                <div class="platforms-title">Disponível em dispositivos:</div>
                <div class="platforms-grid">
                    <div class="platform"><i class="fab fa-apple"></i><div class="platform-name">iOS</div></div>
                    <div class="platform"><i class="fab fa-android"></i><div class="platform-name">Android</div></div>
                    <div class="platform"><i class="fab fa-windows"></i><div class="platform-name">Windows</div></div>
                    <div class="platform"><i class="fas fa-tv"></i><div class="platform-name">Smart TV</div></div>
                </div>
            </div>
        </div>
    `;
}

async function loadSeriesDetail(id) {
    const data = await getSeriesDetails(id);
    const episodes = data.number_of_seasons > 0 ? await getSeasonEpisodes(id, 1) : null;
    const content = document.getElementById('detailContent');
    
    const poster = data.poster_path ? `${TMDB_IMAGE_BASE}${data.poster_path}` : 'https://via.placeholder.com/350x525/1a1a1a/2196F3?text=Série';
    const title = data.name;
    const overview = data.overview || 'Sem descrição disponível.';
    const genres = data.genres.map(g => g.name).join(', ');
    const firstAirDate = data.first_air_date ? new Date(data.first_air_date).toLocaleDateString('pt-BR') : 'N/A';
    const totalEpisodes = data.number_of_episodes || 0;
    const creator = data.created_by?.[0]?.name || 'N/A';
    const cast = data.credits?.cast?.slice(0, 5).map(c => c.name).join(', ') || 'N/A';
    const trailer = data.videos?.results?.find(v => v.type === 'Trailer' && v.site === 'YouTube');
    
    let episodesHTML = '';
    if (episodes && episodes.episodes) {
        episodesHTML = `
        <div class="episodes-section" style="margin-top:3rem;background:#1a1a1a;padding:2rem;border-radius:12px">
            <div style="background:#2196F3;color:#FFF;padding:1rem 1.5rem;border-radius:8px;font-size:1.2rem;font-weight:600;margin-bottom:1.5rem">TEMPORADA: 1</div>
            <table style="width:100%;border-collapse:collapse">
                <thead style="background:#2C2C2C">
                    <tr>
                        <th style="padding:1rem;text-align:left;color:#2196F3;font-weight:600;text-transform:uppercase;font-size:0.85rem">#</th>
                        <th style="padding:1rem;text-align:left;color:#2196F3;font-weight:600;text-transform:uppercase;font-size:0.85rem">Episódio</th>
                        <th style="padding:1rem;text-align:left;color:#2196F3;font-weight:600;text-transform:uppercase;font-size:0.85rem">Duração</th>
                    </tr>
                </thead>
                <tbody>
                    ${episodes.episodes.map(ep => `
                        <tr style="border-bottom:1px solid #333">
                            <td style="padding:1rem;color:#FFF">${ep.episode_number}</td>
                            <td style="padding:1rem;color:#FFF">S01E${ep.episode_number.toString().padStart(2, '0')} - ${ep.name}</td>
                            <td style="padding:1rem;color:#FFF">${ep.runtime ? `${ep.runtime}min` : 'N/A'}</td>
                        </tr>
                    `).join('')}
                </tbody>
            </table>
        </div>`;
    }
    
    content.innerHTML = `
        <div class="detail-page">
            <h1 class="detail-title-main">${title.toUpperCase()}</h1>
            <div class="detail-container">
                <div class="poster-section">
                    <img src="${poster}" alt="${title}" class="poster-img">
                </div>
                <div class="info-section">
                    ${genres ? `<div class="info-row"><div class="info-label">Gênero:</div><div class="info-value">${genres}</div></div>` : ''}
                    ${totalEpisodes ? `<div class="info-row"><div class="info-label">Total de Episódios:</div><div class="info-value">${totalEpisodes}</div></div>` : ''}
                    ${cast !== 'N/A' ? `<div class="info-row"><div class="info-label">Elenco:</div><div class="info-value">${cast}</div></div>` : ''}
                    ${creator !== 'N/A' ? `<div class="info-row"><div class="info-label">Criador:</div><div class="info-value">${creator}</div></div>` : ''}
                    <div class="description">${overview}</div>
                    <div class="info-row"><div class="info-label">Categoria:</div><div><span class="category-badge">${genres.split(',')[0] || 'SÉRIE'}</span></div></div>
                </div>
            </div>
            ${trailer ? `
            <div class="trailer-section">
                <h2 class="trailer-title">🎬 Trailer</h2>
                <div class="trailer-player">
                    <iframe src="https://www.youtube.com/embed/${trailer.key}" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                </div>
            </div>` : ''}
            ${episodesHTML}
            <div class="platforms">
                <div class="platforms-title">Disponível em dispositivos:</div>
                <div class="platforms-grid">
                    <div class="platform"><i class="fab fa-apple"></i><div class="platform-name">iOS</div></div>
                    <div class="platform"><i class="fab fa-android"></i><div class="platform-name">Android</div></div>
                    <div class="platform"><i class="fab fa-windows"></i><div class="platform-name">Windows</div></div>
                    <div class="platform"><i class="fas fa-tv"></i><div class="platform-name">Smart TV</div></div>
                </div>
            </div>
        </div>
    `;
}
