// Funções para TMDB API

async function getPopularMovies(page = 1) {
    const includeAdult = localStorage.getItem(ADULT_FILTER_KEY) === 'true';
    const url = `${TMDB_BASE_URL}/movie/popular?api_key=${TMDB_API_KEY}&language=pt-BR&page=${page}&include_adult=${includeAdult}`;
    const response = await fetch(url);
    const data = await response.json();
    return data.results || [];
}

async function getPopularSeries(page = 1) {
    const includeAdult = localStorage.getItem(ADULT_FILTER_KEY) === 'true';
    const url = `${TMDB_BASE_URL}/tv/popular?api_key=${TMDB_API_KEY}&language=pt-BR&page=${page}&include_adult=${includeAdult}`;
    const response = await fetch(url);
    const data = await response.json();
    return data.results || [];
}

async function getMovieDetails(id) {
    const url = `${TMDB_BASE_URL}/movie/${id}?api_key=${TMDB_API_KEY}&language=pt-BR&append_to_response=videos,credits`;
    const response = await fetch(url);
    return await response.json();
}

async function getSeriesDetails(id) {
    const url = `${TMDB_BASE_URL}/tv/${id}?api_key=${TMDB_API_KEY}&language=pt-BR&append_to_response=videos,credits`;
    const response = await fetch(url);
    return await response.json();
}

async function getSeasonEpisodes(seriesId, seasonNumber) {
    const url = `${TMDB_BASE_URL}/tv/${seriesId}/season/${seasonNumber}?api_key=${TMDB_API_KEY}&language=pt-BR`;
    const response = await fetch(url);
    return await response.json();
}

async function searchTMDB(query, page = 1) {
    const includeAdult = localStorage.getItem(ADULT_FILTER_KEY) === 'true';
    const url = `${TMDB_BASE_URL}/search/multi?api_key=${TMDB_API_KEY}&language=pt-BR&query=${encodeURIComponent(query)}&page=${page}&include_adult=${includeAdult}`;
    const response = await fetch(url);
    const data = await response.json();
    return data.results || [];
}

const movieGenres = {28:'Ação',12:'Aventura',16:'Animação',35:'Comédia',80:'Crime',99:'Documentário',18:'Drama',10751:'Família',14:'Fantasia',36:'História',27:'Terror',10402:'Música',9648:'Mistério',10749:'Romance',878:'Ficção Científica',10770:'Cinema TV',53:'Thriller',10752:'Guerra',37:'Faroeste'};
const tvGenres = {10759:'Ação & Aventura',16:'Animação',35:'Comédia',80:'Crime',99:'Documentário',18:'Drama',10751:'Família',10762:'Kids',9648:'Mistério',10763:'News',10764:'Reality',10765:'Sci-Fi & Fantasy',10766:'Soap',10767:'Talk',10768:'War & Politics',37:'Faroeste'};
